/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.ErpObjectContainer;
import itx.erp.helper.ErpConfig;
import itx.erp.sales.conf.SalesSettings;
import itx.erp.sales.model.Invoice;
import itx.erp.sales.model.InvoiceLine;
import itx.erp.sales.model.Vat;
import itx.erp.sales.pdf.InvoicePdf;
import itx.erp.sales.service.ArticleService;
import itx.erp.sales.service.InvoiceService;
import itx.erp.sales.validator.InvoiceValidator;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.InvalidStateException;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.util.ProcUtil;

public class InvoiceController
extends BaseController {
    protected ErpConfig appConfig;
    protected InvoiceService invoiceService;
    protected ArticleService articleService;
    protected SalesSettings salesSettings;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public InvoiceService getInvoiceService() {
        return this.invoiceService;
    }

    public void setInvoiceService(InvoiceService invoiceService) {
        this.invoiceService = invoiceService;
    }

    public ArticleService getArticleService() {
        return this.articleService;
    }

    public void setArticleService(ArticleService articleService) {
        this.articleService = articleService;
    }

    public SalesSettings getSalesSettings() {
        return this.salesSettings;
    }

    public void setSalesSettings(SalesSettings salesSettings) {
        this.salesSettings = salesSettings;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void searchAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException {
        Integer pageNo = req.getParamInt("pageNo", 0);
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", pageNo * this.appConfig.getLimit());
        opts.put("pageSize", this.appConfig.getLimit());
        opts.put("q", req.getParameter("q"));
        QueryResult<Invoice> qrs = this.invoiceService.searchInvoices(opts);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("salesSettings", this.salesSettings);
        result.put("invoices", qrs.getObjects());
        result.put("start", qrs.getStart());
        result.put("pageSize", qrs.getPageSize());
        result.put("rowCount", qrs.getRowCount());
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer inv_id = req.getParamInt("invoiceId");
        Invoice i = this.invoiceService.readInvoice(inv_id);
        HashMap<String, Invoice> result = new HashMap<String, Invoice>();
        result.put("invoice", i);
        req.renderJson(result);
    }

    public void configAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        List<Vat> vats = this.articleService.readVats();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("salesSettings", this.salesSettings);
        result.put("vats", vats);
        result.put("success", true);
        req.renderJson(result);
    }

    public void saveAction(WebRequest req) throws SQLException, JTBException, IOException {
        Integer invoiceId = req.getParamInt("invoiceId");
        Invoice i = invoiceId != null ? this.invoiceService.readInvoice(invoiceId) : new Invoice();
        i.setInvoiceDate(req.getParamDate("invoiceDate"));
        i.setCustomerId(req.getParamInt("customerId"));
        i.setInvoiceStatus(req.getParameter("invoiceStatus"));
        i.setSubject(req.getParameter("subject"));
        i.setComment(req.getParameter("comment"));
        i.setInternalNote(req.getParameter("internalNote"));
        List<KeyValueList> lines = req.getKvl().getList("lines");
        i.getLines().clear();
        int cnt = 0;
        for (KeyValueList l : lines) {
            Vat v;
            String lineType = l.getValue("lineType");
            InvoiceLine il = new InvoiceLine();
            il.setLineType(lineType);
            il.setSort(cnt++);
            if ("text".equals(lineType)) {
                il.setShortDescription(l.getValue("shortDescription"));
                il.setShortDescription2(l.getValue("shortDescription2"));
            }
            if ("price".equals(lineType)) {
                il.setShortDescription(l.getValue("shortDescription"));
                il.setAmount(l.getValueDouble("amount"));
                il.setVatPercentage(l.getValueDouble("vatPercentage"));
                v = new Vat();
                v.setPercentage(il.getVatPercentage());
                if (this.salesSettings.inputPriceExclVat()) {
                    il.setPriceExclVat(l.getValueDouble("price"));
                    il.setPriceInclVat(v.addVat(il.getPriceExclVat()));
                } else {
                    il.setPriceInclVat(l.getValueDouble("price"));
                    il.setPriceExclVat(v.subtractVat(il.getPriceInclVat()));
                }
            }
            if ("article".equals(lineType)) {
                il.setArticleId(l.getValueInt("articleId"));
                il.setSlotplanPricetypeId(l.getValueInt("pricetypeId"));
                il.setShortDescription(l.getValue("shortDescription"));
                il.setAmount(l.getValueDouble("amount"));
                il.setVatPercentage(l.getValueDouble("vatPercentage"));
                v = new Vat();
                v.setPercentage(il.getVatPercentage());
                if (this.salesSettings.inputPriceExclVat()) {
                    il.setPriceExclVat(l.getValueDouble("price"));
                    il.setPriceInclVat(v.addVat(il.getPriceExclVat()));
                } else {
                    il.setPriceInclVat(l.getValueDouble("price"));
                    Double piv = il.getPriceInclVat();
                    Double pev = v.subtractVat(piv);
                    il.setPriceExclVat(pev);
                }
            }
            i.getLines().add(il);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        InvoiceValidator validator = new InvoiceValidator();
        if (validator.validate(i)) {
            invoiceId = this.invoiceService.saveInvoice(i);
            result.put("invoiceId", invoiceId);
            result.put("success", true);
        } else {
            result.put("error", true);
            result.put("errors", validator.getErrors());
        }
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws SQLException, JTBException, IOException {
        Integer id = req.getParamInt("invoiceId");
        this.invoiceService.deleteInvoice(id);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void printAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer invoiceId = req.getParamInt("id");
        Invoice i = this.invoiceService.readInvoice(invoiceId);
        InvoicePdf pdf = new InvoicePdf(i);
        HttpServletResponse resp = req.getResponse();
        resp.setContentType("application/pdf");
        resp.setHeader("Content-Disposition", "inline; filename=\"invoice-" + String.valueOf(i.getInvoiceNumber()) + ".pdf\"");
        ServletOutputStream os = resp.getOutputStream();
        pdf.save((OutputStream)os);
        os.close();
    }

    public void openInvoiceAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        if (!this.appConfig.isDesktopMode()) {
            throw new InvalidStateException("Not in desktop mode");
        }
        Integer invoiceId = req.getParamInt("id");
        Invoice i = this.invoiceService.readInvoice(invoiceId);
        InvoicePdf pdf = new InvoicePdf(i);
        String d = ErpObjectContainer.getInstance().getDataDir() + "/invoices";
        File invoiceDir = new File(d);
        if (!invoiceDir.exists()) {
            invoiceDir.mkdir();
        }
        String p = invoiceDir.getAbsolutePath() + "/invoice-" + String.valueOf(i.getInvoiceId()) + ".pdf";
        pdf.save(p);
        ProcUtil.openUrlInBrowser(p);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }
}

